#pragma body

float mpi = 3.1415926535897932384626433832795;

float3 innormal = _geometry.normal;
/*
 has seam:
 -----------
float2 uv = float2(

      // atan returns a value between -pi and pi
      (1.0 + atan2(innormal.x, innormal.z) / mpi) * 0.5,
      
      (1.0 + acos(innormal.y) / mpi) * 2.0
    );
    
_geometry.texcoords[0] = uv;
 -----------
*/

// seam avoidance with strategy from https://bgolus.medium.com/rendering-a-sphere-on-a-quad-13c92025570c
float phi = (1.0 + atan2(innormal.x, innormal.z) / mpi) * 0.5;
float phi_fract = fract(phi);
float u = phi;
u = phi_fract;


if (phi < 1-0.0001) { u = phi;} else {u = phi_fract;}
//if (phi < 1.001) { u = phi;} else {u = phi_fract;}
float2 uv = float2(

    // uses a small bias to prefer the first 'UV set'
    // fwidth(phi) < fwidth(phi_fract) - 0.001 ? phi : phi_fract,
                   -u,//_fract,
      (1.0 + acos(innormal.y) / mpi) * 2.0
    );
    

_geometry.texcoords[0] = uv;
